//common code for taking a picture
void camcam(){

  //take a picture now
  if (! cam.takePicture()){ 
#if DebugLevel >=1
    Serial.println(F("Image failed"));
#endif
  }
  else {
#if DebugLevel >=3
    Serial.println(F("Image taken"));
#endif
  }

  //make a filename
  strcpy(pfilename, "awcs000.jpg");
  pfilename[4] = (fname/100)%10 + '0'; //To get 1st digit from fname
  pfilename[5] = (fname/10)%10 + '0'; //To get 2nd digit from fname
  pfilename[6] = fname%10 + '0'; //To get 3rd digit from fname

  //if filename already exists, remove it.
  if (SD.exists(pfilename)) {
    SD.remove(pfilename);     
  }

  //determine next number in naming sequence for later
  fname++;
  if (fname >= maxpics){
    fname=0;
  }

  //begin wiritng data to sd card
  digitalWrite(BusyLED, HIGH);

  //open the new file
  File imgFile = SD.open(pfilename, FILE_WRITE);

  //get image size from camera
  uint16_t jpglen = cam.frameLength();

#if DebugLevel >=2
  Serial.print(jpglen, DEC);
  Serial.print(F(" bytes going to /"));
  Serial.print(pfilename);
#endif

//write image data to SD card
  while (jpglen > 0) {
    // read 32 bytes at a time;
    uint8_t *buffer;
    uint8_t bytesToRead = min(32, jpglen); // change 32 to 64 for a speed-up but may not work with all setups!
    buffer = cam.readPicture(bytesToRead);
    imgFile.write(buffer, bytesToRead);

    jpglen -= bytesToRead;
  }
  imgFile.close();
  
  //note the time for xml data
  lastpic = millis();
  
  //resume camera stream
  cam.resumeVideo();

#if DebugLevel >=2
  Serial.println(F("..done"));   
#endif

//we're done here
  digitalWrite(BusyLED, LOW);
}








