//tests camera function and sets resolution
void camcamtest() { 

  //wake up the camera
  if (cam.begin()) {
#if DebugLevel >= 3
    Serial.print(F("Cam on. "));
#endif
  } 
  else {
#if DebugLevel >= 1
    Serial.print(F("Cam err. "));
#endif
  } 

  //wait for camera to wake up
  delay(500);

  //set chosen image size
  if(cammode == 3){
    cam.setImageSize(VC0706_640x480);          // large
  }
  else if(cammode == 2){
    cam.setImageSize(VC0706_320x240);          // med
  }
  else{
    cam.setImageSize(VC0706_160x120);          // small
  }

  //this seems necessary for on-the-run image size changing
  cam.begin();
  for(byte i=0;i<5;i++){
    cam.getImageSize();
  }

  //get set size
  uint8_t imgsize = cam.getImageSize();

#if DebugLevel >= 3
  Serial.print("Img size:");
  if (imgsize == VC0706_640x480) Serial.println(F("640x480"));
  else if (imgsize == VC0706_320x240) Serial.println(F("320x240"));
  else if (imgsize == VC0706_160x120) Serial.println(F("160x120"));
  else Serial.println(F("err"));
#endif

  //you can apparently set exposure with this
  //~500ms+ == proper exposure
  //anything less == darker exposure
  delay(500); 

}























