//Common code for outputting dynamic XML data upon request
void dataReq(EthernetClient client) {

  client.println(F("HTTP/1.1 200 OK"));
  client.println(F("Content-Type: text/xml"));
  client.println(F("Connection: close"));
  client.println(F("Cache-Control: no-cache, max-age=0"));
  client.println();

  client.print(F("<?xml version = \"1.0\" ?>"));
  client.print(F("<xml>"));

  client.print(F("<id>"));
  client.print(pfilename);
  client.print(F("</id>"));

  client.print(F("<age>"));
  tslp = (millis() - lastpic) / 1000;
  client.print(tslp);  
  client.print(F("</age>"));

  client.print(F("<A0>"));
  //we are using an LM34 on A0
  client.print(analogRead(A0)/10);
  client.print(F("</A0>"));

  client.print(F("<mp>"));
  client.print(maxpics);
  client.print(F("</mp>"));

  client.print(F("<hit>"));
  client.print(hits);
  client.print(F("</hit>"));

  client.print(F("<up>"));
  client.print(millis());
  client.print(F("</up>"));

  client.print(F("<size>"));
  uint8_t imgsize = cam.getImageSize();
  if (imgsize == VC0706_640x480) client.print(F("640x480"));
  else if (imgsize == VC0706_320x240) client.print(F("320x240"));
  else if (imgsize == VC0706_160x120) client.print(F("160x120"));
  else client.print(F("err"));
  client.print(F("</size>"));

  client.print(F("<lo>"));
  if (load < 50) client.print(F("idle"));
  else client.print(F("high"));
  //Serial.print(load);
  client.print(F("</lo>"));

  client.print(F("</xml>"));

}



